/**********
* File: CDGL_IDirect3DBaseTexture9.h

* Brief Description: This file contains the declaration of the class CDGL_IDirect3DBaseTexture9. 
					 This class is our concrete implementation of IDirect3DBaseTexture9 interface in Direct3D9. The class IDirect3DBaseTexture9 is made as an abstract class in d3d9.h (DXInclude)file.

* Written By: Shilpa Prabhu

* Copyright: 1994-2004 by Robosoft Technologies, all rights reserved.

* Date Of Creation: 08Nov04

* Change History (Most Recent First):

 * Modified by  : Bala 

**********/

#ifndef __CDGL_IDIRECT3DTEXTURE9_H__
#define __CDGL_IDIRECT3DTEXTURE9_H__

#include <Carbon/Carbon.h>
#include <iostream>

#ifndef LIB_CHANGES
#include "OZone/ITexture.h"
#else
#include "ITexture.h"
#endif	// LIB_CHANGES

#include "CDGL_IDirect3DSurface9.h"
#include "d3d9.h"

class CDGL_IDirect3DTexture9 : public IDirect3DTexture9
{
	public:	
	
		CDGL_IDirect3DTexture9(IDirect3DDevice9 *m_pDevice, UINT Width, UINT Height, UINT Levels, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool);
		~CDGL_IDirect3DTexture9();
		
		//! IUnknown methods
		HRESULT QueryInterface(REFIID, void **ppvObj);
		ULONG AddRef();
		ULONG Release();
		
		//! IDirect3DResource9 methods
		HRESULT FreePrivateData(REFGUID refguid);
		HRESULT GetDevice(IDirect3DDevice9 **ppDevice);
		DWORD   GetPriority();
		HRESULT GetPrivateData(REFGUID refguid, void *pData, DWORD *pSizeOfData);
		D3DRESOURCETYPE GetType();
		void PreLoad();
		DWORD SetPriority(DWORD PriorityNew);
		HRESULT SetPrivateData(REFGUID refguid, CONST void *pData, DWORD SizeOfData, DWORD Flags);
		
		//! IDirect3DBaseTexture9 methods
		DWORD GetLevelCount();
		DWORD GetLOD();
		DWORD SetLOD(DWORD Lodnew);
		HRESULT SetAutoGenFilterType( D3DTEXTUREFILTERTYPE FilterType);
		D3DTEXTUREFILTERTYPE GetAutoGenFilterType();
		void GenerateMipSubLevels();
		
		//! IDirect3DTexture9 methods
		HRESULT AddDirtyRect(CONST RECT *pDirtyRect);
		HRESULT GetLevelDesc(UINT Level, D3DSURFACE_DESC *pDesc);
		HRESULT GetSurfaceLevel(UINT Level, IDirect3DSurface9 **ppSurfaceLevel);
		HRESULT LockRect(UINT Level, D3DLOCKED_RECT *pLockedRect, CONST RECT *pRect, DWORD Flags);
		HRESULT UnlockRect(UINT Level);
		
		//! Additional methods
			
		void					BindTexture();
		//! Gives back the pointer to the local image of a level.
//		void**					GetLocalImage(UINT in_lLevel) { return &(m_pLocalImage[in_lLevel]); }
//		//! Sets the local image of a mip level
//		void					SetLocalImage(UINT in_lLevel, void *in_pData) { m_pLocalImage[in_lLevel] = in_pData; }
		//! Gives back the texture id.
		GLuint					GetGLHandle() { return m_lGlHandle; }
		//! Returns the Device pointer associated with this texture
		IDirect3DDevice9 *		GetDevice() { return m_pDevice; }
		//! Returns the image width of a mip level
		UINT					GetWidth(UINT in_lLevel) { return m_lWidth >> in_lLevel; }
		//! Returns the image height of a mip level
		UINT					GetHeight(UINT in_lLevel) { return m_lHeight >> in_lLevel; }
		//! Returns the Format of the texture
		D3DFORMAT				GetFormat() { return m_Format; }
		
		ITexture 				GetSmartTexture();
		void					SubmitTextureData(UINT );
		void					SetDirtyFlag(bool);
		bool					GetDirtyFlag();

	protected:
	
		IDirect3DDevice9 *		m_pDevice;	
		
		UINT					m_lWidth; 
		UINT					m_lHeight;
		UINT					m_lLevels;
		DWORD					m_dwUsage;
		D3DFORMAT				m_Format;
		D3DPOOL					m_Pool;
		DWORD					m_dwLod;
		DWORD					m_dwPriority;
		int						m_lRefCount;
		GLuint					m_lGlHandle;
		GLint					m_lInternalFmt;
		GLenum					m_TextureFmt;
		GLenum					m_TextureType; //Shilpa on 28 Jan 05
		
		// bala : using surfaces to store mips instead of holding raw memory pointer
		//void			**		m_pLocalImage; 
		CDGL_IDirect3DSurface9 **mSurfaces;	
	

		int						m_lPitch; 
		bool					m_bAutoGenMipmaps; //Shilpa on 7 Feb 05 - to support auto generation of mipmaps.
	
		// |≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈• SMARTDX •≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈≈|
		bool					mIsTextureDirty;
		ITexture 				mTexture;
		IRenderTexture			mRenderTexture;

	
		void					_initTextureSurfaces();
	
};


#endif
